% load some actual radar data (from my low budget uncalibrated home-made radar)
load -force car3.txt   % load radar return from a car coming up behind me
zcal=ccal(car3);       % complexify, subtract mean, set to unit covz, etc..
                       % roughly uniform acceleration
zp=zcal(12000:12000+3999);% take part of data (about 4000 samples is half sec.
                       % and the car was roughly uniform accel during this time
freqfrac = 0.25 %  (0.5 is the maximum value)
disp('about to compute chirplet transform: takes a while')
Zff=ff(zp,freqfrac,199);% takes a long time (see Bug notice in help)
                       % so try looking at part of the data or decimating the
                       % data by a factor of 2:
[M,N]=size(Zff);
X=linspace(-freqfrac,freqfrac,N);
Y=linspace(-freqfrac,freqfrac,M);
tvs(X,-Y,-abs(Zff)); grid; %%% axis('xy);
xlabel('FREQ. BEG.')
ylabel('FREQ. END')
title('CHIRPLET TRANSFORM')

