%mulz.m                                                Steve Mann, 2000
%
%multiply [real, imag] parts of complex valued vector by a 2 by 2 matrix
%
%example usage: q=inv(chol(covz(z)));
%               zq = mulz(z,q);
%gives znormalized such that covz(zq) is the identity matrix
%see also covz.m

function zq = mulz(z,q);

if nargin ~= 2
  error('must have exactly 2 input arguments')
end%if

if min(size(z))>1
  error('first input must be a vector')
end%if

if size(q) ~= [2 2];
  error('second input must be a 2 by 2 matrix')
end%if

x=real(z); y=imag(z); zxy=[x y];

zq=zxy*q;
zq = zq(:,1) + i*zq(:,2);

