% calculates and displays Time Freq. (time varying FFT), frac. freq. of halfway

function returnsnothing(z)

[M,N]=size(z);

if min(M,N)>1
  error('input must be 1d (e.g. a vector) not a 2d image (matrix)')
end%if

ZZ=tfmann(z,500,500,2); % doubles the length
%tvfortf(ZZ(250:250+500,:)); % incorporate directly modified version below:
% for proper axes labels, i'll include+modify tvfortf.m below:

ZZ=ZZ(250:250+500,:); % take out center portion

ZZabs = abs(ZZ);
[M,N]=size(ZZ);
if max(M,N)<3; % it's probably not an image
  error('input must be a 2 dimensional image, not a vector')
end%if
clear ZZ
threshold = .001;  % good default threshold
ZZmin = min(min(ZZabs));
ZZmax = max(max(ZZabs));
% normalize on [0,1] to have a meaningful threshold
ZZsc = (ZZabs-ZZmin)/(ZZmax-ZZmin);
clear ZZabs
ZZlog = log(ZZsc+threshold); % easier to see on a log scale
clear ZZsc

%X=1:N; % time sample index
X=linspace(0,(length(z)-1)/8000,N); % time in seconds, assuming 8khz sampling 
%Y=-ceil((M-1)/2):floor((M-1)/2);
Y=linspace(-.25,.25,M);
%tvs(flipud(-ZZlog)) % need flipud because axis 'xy' also flips image
tvs(X,Y,flipud(-ZZlog)) % need flipud because axis 'xy' also flips image
          %^^^^^^this -ZZlog saves toner by making the image black on white
grid; xlabel('TIME'); ylabel('FREQUENCY'); axis('xy')
axis('normal') % doesn't affect xy, but allows anisotropic...

