% this is a camera simulator
%
% you give it a focus parameter (a number from 0 to 199)
% and it returns a picture focused to that focus parameter (distance).

function y=takepicture(n)

if imag(n)>eps
  disp("takepicture requires a real focus setting.  Get Real!");
  return
end%if
if max(size(n))>1
  disp("takepicture requires a scalar focus setting.");
  return
end%if

n=round(n); % image frame index must be integer

if n<0
  disp("takepicture requires a non negative focus setting.");
  return
end%if
if n>199
  disp("takepicture requires a focus setting from 0 to 199.");
  return
end%if

eval(sprintf("y=imread(""v%03d.jpg"",""jpeg"");",n));

