% adds extra samples; interpolates an even length sequence to even or odd
% useful for converting a 254 long vector from zeroing out endpoints
% (as in comparunroll window) to 255 or 256 long

function c_interp = interp_even_to(c,padlen);

if nargin<2
  padlen=1;  % by default, insert one additional zero for padding
end%if

C=fft(c);
[M,N]=size(c);
if min(M,N) > 1
  error('interp_even_to: input must be a vector quanity\n');
end%if
L = max(M,N); % length of vector
if round(L/2)*2 ~= L
  error('interp_even_to: input must have an even number of samples\n');
end%if
C=C(:);
padlen=padlen+1; % since we get rid of freq. component at pi/2 must have 1 extra
pad=zeros(padlen,1);
c_interp = ifft([[C(1:L/2);pad;C(L/2+1+1:L)]]); % sample L/2+1 is never used

