#include <stdio.h>
#include <math.h>
#include "mini_ssc.h"

char *usage =
  "USAGE:\n"
  "  autofocus 55 puts focus servo at closest.\n"
  "  autofocus 254 puts servo at infinity.\n"
  "  autofocus 22-54 would damage camera mount, so filtered out in program.\n"
  "  autofocus 0-21 would damage servo, so filtered out in program.\n"
  "  servo range is 22-254 but camera range is 55-254.\n"
  "  for convenience, 55 is added to input number to get 0..199 into range,\n"
  "  so enter any number from 0 to 199\n";

// range used to be 73 to 238

int main(int argc,char **argv)
{
  int port, baudrate, servo, min, max, delay, step;

  char *s;
  int i,n,z;
  int x_in, y_in;
  int x_out, y_out;

  // defaults
  port     = 0;
  baudrate = 2400;

  // get parameter values
  if (argc==2){
    x_in = atoi(argv[1]);
  }
  else {
    fprintf(stderr,"%s",usage);
    exit(-1);
  }

  x_in = x_in + 55;
  if (x_in > 254){
    x_in = 254;
    fprintf(stderr,"input greater than 254 is clipped to 254\n");
    fprintf(stderr,"you should enter only numbers from 0 to 199\n");
  }
  if (x_in < 22){
    x_in = 22;
    fprintf(stderr,"input less than 22 damages servo, so clipped to 22\n");
    fprintf(stderr,"you should enter only numbers from 0 to 199\n");
  }
  if (x_in < 55){
    x_in = 55;
    fprintf(stderr,"input less than 55 damages mount, so clipped to 55\n");
    fprintf(stderr,"you should enter only numbers from 0 to 199\n");
  }
  
  // connect to the ssc
  if(!ssc_open(port,baudrate)){
  
    // enter infinite loop that translates pairs of screen coordinates
    // to pairs of telepointer coodinates.
    
    ssc_move( 0, x_in  );
  
    fprintf(stderr,"%d\n", x_in);
  }
}

